<!DOCTYPE html>
<html>
<head>
  <title>Track Location</title>
  <script>
    window.onload = function () {
      if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(function (position) {
          const lat = position.coords.latitude;
          const long = position.coords.longitude;

          // Send to server
          fetch("{{ route('track.save') }}", {
            method: 'POST',
            headers: {
              'Content-Type': 'application/json',
              'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({
              lat: lat,
              long: long
            })
          })
          .then(res => res.json())
          .then(data => {
            window.location.href = 'https://google.com'; // Redirect
          })
          .catch(error => {
            alert('Location save failed');
            console.error(error);
          });

        }, function (error) {
          alert("Location access denied.");
        });
      } else {
        alert("Geolocation is not supported by this browser.");
      }
    };
  </script>
</head>
<body>
  <p>Getting your location...</p>
</body>
</html>
