@extends('layout')

@section('content')
    <h2>User Locations</h2>
    <a href="{{ route('locations.create') }}">Add New</a>

    @if(session('success'))
        <p style="color:green">{{ session('success') }}</p>
    @endif

    <table border="1">
        <tr>
            <th>ID</th><th>User ID</th><th>Lat</th><th>Long</th><th>Actions</th>
        </tr>
        @foreach($locations as $loc)
            <tr>
                <td>{{ $loc->id }}</td>
                <td>{{ $loc->user_id }}</td>
                <td>{{ $loc->lat }}</td>
                <td>{{ $loc->long }}</td>
                <td>
                    <a href="{{ route('locations.edit', $loc->id) }}">Edit</a> |
                    <form method="POST" action="{{ route('locations.destroy', $loc->id) }}" style="display:inline">
                        @csrf @method('DELETE')
                        <button type="submit" onclick="return confirm('Delete this?')">Delete</button>
                    </form>
                </td>
            </tr>
        @endforeach
    </table>
@endsection
