<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\UserLocation;

class UserLocationController extends Controller
{
    public function index()
    {
        return response()->json(UserLocation::all());
    }

    public function store(Request $request)
    {
        $location = UserLocation::create($request->only(['user_id', 'lat', 'long']));
        return response()->json(['status' => 'created', 'data' => $location]);
    }

    public function show($id)
    {
        return response()->json(UserLocation::findOrFail($id));
    }

    public function update(Request $request, $id)
    {
        $location = UserLocation::findOrFail($id);
        $location->update($request->only(['user_id', 'lat', 'long']));
        return response()->json(['status' => 'updated', 'data' => $location]);
    }

    public function destroy($id)
    {
        UserLocation::findOrFail($id)->delete();
        return response()->json(['status' => 'deleted']);
    }
}

}
